//=================================================================
// Brdf models
//
// Author : Daniel Meneveaux
// Date   : September 2010
//=================================================================

#ifndef _brdf_h_
#define _brdf_h_

#include "point.hpp"

//=================================================================
// BRDF mother class
//
// WARNING !!!
// Vo corresponds to an observer-pixel direction
//      ==> it should be inverted for all models
//      ==> take care
//=================================================================
class brdf {
protected:
	char m_values[512];  // for rView system

public:

	virtual float fr(pVect Vi, pVect Vo, pVect N) = 0;
	virtual int nbParam() = 0;
	virtual void resetParam(int i) = 0;
	virtual void changeParam(int i, float val) = 0;
	virtual char *paramValues() = 0;
	virtual ~brdf() {};
};

//=================================================================
// LAMBERT model
//=================================================================
class rLambert : public brdf {

private:
	float m_Kd;

public:
	rLambert() { m_Kd=0.6; };
	float fr(pVect Vi, pVect Vo, pVect N);
	int nbParam() { return 1; };
	void resetParam(int i);	
	void changeParam(int i, float val);
	char *paramValues();
};


//=================================================================
// MODIFIED PHONG model
//=================================================================
class rPhong : public brdf {

private:
	float m_Kd, m_Ks;
	int m_Ns;

public:
	rPhong() { m_Kd=0.6; m_Ks=0.07; m_Ns=50; };
	float fr(pVect rVi, pVect rVo, pVect N);
	int nbParam() { return 3; };
	void resetParam(int i);	
	void changeParam(int i, float val);
	char *paramValues();
};


//=================================================================
// COOK-TORRANCE model
//=================================================================
class rCook : public brdf {

private:
	float m_Kd,m_sFo,m_m;


public:
	rCook() { m_Kd=0.6; m_sFo=sqrt(0.04); m_m=0.09; };
	rCook(float Kd, float Fo, float m) { m_Kd=Kd; m_sFo=Fo; m_m=m; };
	float fr(pVect rVi, pVect rVo, pVect N);
	int nbParam() { return 2; };
	void resetParam(int i);	
	void changeParam(int i, float val);
	char *paramValues();
};

//=================================================================
// Oren-Nayar model
//=================================================================
class rOrenNayar : public brdf {

private:
	float m_Kd,m_sigma;

public:
	rOrenNayar(): m_Kd(0.6), m_sigma(1.0f) {};
	float fr(pVect rVi, pVect rVo, pVect N);
	int nbParam() { return 2; };
	void resetParam(int i);	
	void changeParam(int i, float val);
	char *paramValues();
};

#endif

