//=================================================================
// Camera definition for OpenGL
//
// Author : Daniel Meneveaux
// Date   : July 2008
//=================================================================

#include "types.hpp"
#include "point.hpp"
#include "brdf.hpp"
#include "geom3D.hpp"

//=================================================================
#define NO_MODE              0
#define TRACKBALL_MODE       1
#define DISTANCE_MODE        2
#define SRC_MOVE_MODE        3
#define SRC_POW_MODE         4


//=================================================================
class camera {
private:

  // --------------------------------------------------------------
  float m_Rx, m_Ry;                 // camera orientation
  float m_Dist;                     // distance to Xg,Yg,Zg
	float m_angle;                    // Viewing angle
  ushort m_imgWidth,m_imgHeight;    // image size   ???
	float m_srcTheta, m_srcPhi;       // light source position
	float m_srcPow;                   // light source power (white)
  // --------------------------------------------------------------
  int   m_oX, m_oY;									// old mouse position
  float m_oRx, m_oRy; 							// old orientation
  float m_oDist;										// old distance to xg,yg,zg
	pVect m_oSrcPos;                  // old gl lightsource position
	uchar m_modeMouse;                // trackball/distance/move
  // --------------------------------------------------------------
	bool m_seeFps;                    // choose to display fps
	uchar m_wireframe;                // 0:wireframe ; 1:solide; 2:both
	bool m_3Dview;                    // true if 3D view active
	float m_cutPlaneAngle;            // plane used for top BRDF view
	float m_cylPlaneAngle;            // plane used for bottom view
  // --------------------------------------------------------------
  vector<vector<float> > m_vues;    // cDist, RotX, RotY, Xg, Yg, Zg  ???
  uint m_noVue;                     // current viewpoint   ???
  // --------------------------------------------------------------
	brdf *m_Fr;
	brdf *m_fLambert;
	brdf *m_fPhong;
	brdf *m_fCookT;
	brdf *m_fOrenN;
  // --------------------------------------------------------------
	brdfGeom m_model3D;

private:
  // --------------------------------------------------------------
  void gpuInit();                   // opengl context
  void gpuBeginView();              // image initialization
  void gpuEndView();                // image ending
	void gpuBeginView2D();            // begins 2D drawings
	void gpuEndView2D();              // ends 2D drawings

public:

  // --------------------------------------------------------------
  camera(ushort x, ushort y);
  // --------------------------------------------------------------
  void gpuLighting();
  void gpuDrawScene();
	void gpuDrawBRDF(uchar mode);
	void gpuDrawSquare();
	void gpuDrawInOutDirections();
	void gpuDrawCircle(int x,int y,int r);
	void gpuDrawBrdfSplatDisk();
	void gpuDrawBrdfAreaDisk();
	void gpuDrawBrdfCutPlane();
	void gpuDrawBrdfCylinderPlane();
	void gpuDrawInfo();
  // --------------------------------------------------------------
  void setImageSize(ushort x, ushort y);
	void changeIncidentAngle(int val);
	void changeCutPlaneAngle(float val);
	void changeCylPlaneAngle(float val);
	void brdfParam(int id, float val);
	void changeModel();
	void toggleLeftView();
  // --------------------------------------------------------------
  // mouse management for moving camera
  // --------------------------------------------------------------
	void mouseClick(int x, int y, uchar mode);
	void mouseMove(int x, int y);
	void mouseRelease(int x, int y);

	void mouseClickRotation(int x, int y);
	void mouseMoveRotation(int x, int y);
	void mouseReleaseRotation(int x, int y);
	void mouseClickDistance(int x, int y);
	void mouseMoveDistance(int x, int y);
	void mouseReleaseDistance(int x, int y);
	void mouseClickSrcMove(int x, int y);
	void mouseMoveSrcMove(int x, int y);
	void mouseReleaseSrcMove(int x, int y);
	void mouseClickSrcPow(int x, int y);
	void mouseMoveSrcPow(int x, int y);
	void mouseReleaseSrcPow(int x, int y);
  // --------------------------------------------------------------
  // framerate display
  // --------------------------------------------------------------
  void toggleSeeFps();
  bool seeFps() { return m_seeFps;};
  void displayFps();
  // --------------------------------------------------------------
  // display options
  // --------------------------------------------------------------
	void toggleWireframe();

};



