/*
 *  geom3D.cpp
 *  rView
 *
 *  Created by Daniel Meneveaux on 09/02/11.
 *  Copyright 2011 __MyCompanyName__. All rights reserved.
 *
 */

#include <cmath>
#include "geom3D.hpp"

// ======================================================
void brdfGeom::drawIcosaedre(brdf *r, const pVect &Vi,  float srcPow, uchar mode)
{
	m_Fr=r;
	m_Vi=Vi;
	m_mode=mode;
	m_srcPow=srcPow;

	float th0=acos(1.0/sqrt(5)), PI5=M_PI/5.0, PI0=M_PI-th0;
	pVect P0(0,0), P1(th0,0), P2(th0,2*PI5), P3(th0,4*PI5), P4(th0,6*PI5);
	pVect P5(th0,8*PI5), P6(PI0,PI5), P7(PI0,3*PI5), P8(PI0,5*PI5), P9(PI0,7*PI5);
	pVect P10(PI0,9*PI5), P11(M_PI,0);
	
	if(mode==GL_POLYGON) {
		glEnable(GL_BLEND);
		GLfloat mat_diff[] = { 0.7, 0.5, 0.2, 0.7 }; 
		glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_diff); 
		GLfloat mat_spec[] = { 0.5, 0.5, 0.5, 1.0 }; 
		glMaterialfv(GL_FRONT, GL_SPECULAR, mat_spec);
		GLfloat mat_shin[] = { 100.0 }; 
		glMaterialfv(GL_FRONT, GL_SHININESS, mat_shin); 
		glEnable(GL_LIGHTING);	
	} else {
		glDisable(GL_LIGHTING);
		glColor3f(0.0,0.0,0.0);	
	}
	
	drawTrianglesSemiIco(P0,P1,P2);
	drawTrianglesSemiIco(P0,P2,P3);
	drawTrianglesSemiIco(P0,P3,P4);
	drawTrianglesSemiIco(P0,P4,P5);
	drawTrianglesSemiIco(P0,P5,P1);
	drawTrianglesSemiIco(P1,P6,P2);
	drawTrianglesSemiIco(P2,P7,P3);
	drawTrianglesSemiIco(P3,P8,P4);
	drawTrianglesSemiIco(P4,P9,P5);
	drawTrianglesSemiIco(P5,P10,P1);
	drawTrianglesSemiIco(P2,P6,P7);
	drawTrianglesSemiIco(P3,P7,P8);
	drawTrianglesSemiIco(P4,P8,P9);
	drawTrianglesSemiIco(P5,P9,P10);
	drawTrianglesSemiIco(P1,P10,P6);
	
	if(mode==GL_LINE_LOOP) {
		glEnable(GL_LIGHTING);
	}	
}


// ======================================================
void brdfGeom::drawTrianglesSemiIco(const pVect &a, const pVect &b, const pVect &c)
{
	pVect ap=(b+c)/2.0, bp=(a+c)/2.0, cp=(a+b)/2.0;
	ap.normalize();
	bp.normalize();
	cp.normalize();
	
	drawTriangleSub(a,cp,bp,1);
	if(b.z<0 && c.z<0) return;
	drawTriangleSub(bp,cp,ap,1);
	drawTriangleSub(bp,ap,c,1);
	if(b.z<0) return;
	drawTriangleSub(cp,b,ap,1);
}

// ======================================================
void brdfGeom::drawTriangleSub(const pVect &a,const pVect &b,const pVect &c,int nrec)
{
	pVect N(0,0,1);
	
	pVect n1(a),n2(b),n3(c);
	n1.normalize();
	n2.normalize();
	n3.normalize();
	
	pVect s1(n1), s2(n2), s3(n3);
	s1*=m_Fr->fr(m_Vi,-s1,N)*m_srcPow;
	s2*=m_Fr->fr(m_Vi,-s2,N)*m_srcPow;
	s3*=m_Fr->fr(m_Vi,-s3,N)*m_srcPow;
	
	float l1=(s2-s1).sqrNorm();
	float l2=(s3-s1).sqrNorm();
	float l3=(s3-s2).sqrNorm();
	if(nrec>2 && (nrec>5 || pFloat::max(l1,l2,l3)<0.001)) {
	//if(nrec==4) {
		if(m_mode==GL_LINE_LOOP) {
			s1*=1.002;
			s2*=1.002;
			s3*=1.002;
		}
		glBegin(m_mode);
			glNormal3f(n1.x, n1.y, n1.z);
			glVertex3f(s1.x, s1.y, s1.z);
			glNormal3f(n2.x, n2.y, n2.z);
			glVertex3f(s2.x, s2.y, s2.z);
			glNormal3f(n3.x, n3.y, n3.z);
			glVertex3f(s3.x, s3.y, s3.z);
		glEnd();
	} else {
		pVect ap=(b+c)/2.0, bp=(a+c)/2.0, cp=(a+b)/2.0;
		ap.normalize();
		bp.normalize();
		cp.normalize();	
		drawTriangleSub(a,cp,bp,nrec+1);
		drawTriangleSub(bp,cp,ap,nrec+1);
		drawTriangleSub(bp,ap,c,nrec+1);
		drawTriangleSub(cp,b,ap,nrec+1);
	}
}














