
//=================================================================
// BRDF 3D representation (geometry)
//
// Author : Daniel Meneveaux
// Date   : July 2008
//=================================================================

#ifndef _geom3D_h_
#define _geom3D_h_

#include "brdf.hpp"

class brdfGeom {

private:
	brdf *m_Fr;
	pVect m_Vi;
	uchar m_mode;
	float m_srcPow;

public:

	void drawIcosaedre(brdf *r, const pVect &Vi, float srcPow, uchar mode);
	void drawTrianglesSemiIco(const pVect &a, const pVect &b, const pVect &c);
	void drawTriangleSub(const pVect &a, const pVect &b, const pVect &c, int nrec);
};

#endif

