// ========================================================
// Glut Program for OpenGL display of BRDF
// ========================================================

#include "types.hpp"
#include "camera.hpp"
#include <stdlib.h>


// ========================================================
// Gestion fenetrage windows
// ========================================================
#if defined (WIN32)
#include <windows.h>
static WNDPROC currentWndProc;
static HWND handle  = NULL;

static LRESULT CALLBACK winProc(HWND hwnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
    switch(Msg)
    {
        case WM_CLOSE:
            exit(0);
            break;
        case WM_DESTROY:
            exit(0);
            break;
        default:
            return CallWindowProc(currentWndProc, handle, Msg, wParam, lParam);
            break;
    }
    return 0;
}

static void fixCloseWindowOnWin32()
{
    handle = WindowFromDC(wglGetCurrentDC());
    DragAcceptFiles (handle, TRUE);
    currentWndProc = (WNDPROC)GetWindowLongPtr(handle, GWL_WNDPROC);
    SetWindowLongPtr(handle, GWL_WNDPROC, (long)winProc);
}
#endif //WIN32
// ========================================================


static camera *CAMERA;
static int WINDESC;



// ========================================================
void drawScene()
{
  CAMERA->gpuDrawScene();
}


// ========================================================
void keyboard(unsigned char key, int x, int y )
{
	int mod = glutGetModifiers();

  switch(key) {
  // ------------------------------------------------
  // quit
  // ------------------------------------------------
  case 27:  // touche ESC
        glutDestroyWindow(WINDESC);
		exit(0);
    break;
  // ------------------------------------------------
  // incidentangle management
  // ------------------------------------------------
	case '+':
		CAMERA->changeIncidentAngle(1);
		break;
	case '=':
		CAMERA->changeIncidentAngle(-1);
		break;
  // ------------------------------------------------
  // BRDF parameters management
  // ------------------------------------------------
	case '1': case '2': case '3':	case '4':	case '5':
	case '6':	case '7':	case '8':	case '9':
		char t[2]; t[0]=key;t[1]=0;
		if(mod&/*GLUT_ACTIVE_CTRL*/GLUT_ACTIVE_ALT) CAMERA->brdfParam(atoi(t),-0.01);
		else CAMERA->brdfParam(atoi(t),0.01);
		break;
	case 'w':
		CAMERA->changeModel();
		break;
  // ------------------------------------------------
  // view mode (wireframe,fps,views,etc.)
  // ------------------------------------------------
	case ' ':
		CAMERA->toggleSeeFps();
		break;
	case 'f':
		CAMERA->toggleWireframe();
		break;
	case 'x':
		CAMERA->toggleLeftView();
		break;
	case 'q':
		CAMERA->changeCutPlaneAngle(-1);
		break;
	case 's':
		CAMERA->changeCutPlaneAngle(1);
		break;
	case 'a':
		CAMERA->changeCylPlaneAngle(-1);
		break;
	case 'z':
		CAMERA->changeCylPlaneAngle(1);
		break;
	}
  // ------------------------------------------------
  // end
  // ------------------------------------------------
	glutPostRedisplay();
}


// ========================================================
void keyboardSpecial(int key, int x, int y )
{
  switch(key) {
  case GLUT_KEY_LEFT:break;
  case GLUT_KEY_RIGHT:break;
  case GLUT_KEY_UP:break;
  case GLUT_KEY_DOWN:break;
  case GLUT_KEY_F5:break;
  }
	glutPostRedisplay();
}


// ========================================================
void mouseClick( int button, int state, int x, int y )
{
	int mod = glutGetModifiers();
		
	if(state==1) {
    CAMERA->mouseRelease(x,y);
	} else if(button==0 && mod&(GLUT_ACTIVE_CTRL&GLUT_ACTIVE_SHIFT)) {
		CAMERA->mouseClick(x,y,SRC_POW_MODE);
  } else if(button==0 && mod&GLUT_ACTIVE_SHIFT) {
    CAMERA->mouseClick(x,y,DISTANCE_MODE);
	} else if(button==0 && mod&(GLUT_ACTIVE_CTRL)) {
		CAMERA->mouseClick(x,y,SRC_MOVE_MODE);
  } else if(button==0) {
    CAMERA->mouseClick(x,y,TRACKBALL_MODE);
	} else if(button==2 && mod&GLUT_ACTIVE_SHIFT) {
			CAMERA->mouseClick(x,y,SRC_POW_MODE);
	} else if(button==2) {
			CAMERA->mouseClick(x,y,SRC_MOVE_MODE);
	} else if(button==3) {
	} else if(button==4) {
	}

	glutPostRedisplay();
}

// ========================================================
void mouseMove(int x, int y)
{
  CAMERA->mouseMove(x,y);
	glutPostRedisplay();
}


// ========================================================
void idle()
{
  glutPostRedisplay();
}

// ========================================================
int main( int ac, char **av)
{
	// insert code here...
  glutInit(&ac,av);

  int imgSizeX=1024, imgSizeY=512;
  glutInitWindowSize(imgSizeX,imgSizeY);
  glutInitWindowPosition(200,30);
  glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
  WINDESC = glutCreateWindow("BRDF Viewer");

	glutDisplayFunc(drawScene);
  glutKeyboardFunc(keyboard);
  glutSpecialFunc(keyboardSpecial);
  glutMouseFunc(mouseClick);
  glutMotionFunc(mouseMove);
  //glutIdleFunc(idle);

	CAMERA = new camera(imgSizeX,imgSizeY);

	#if defined (WIN32)
    fixCloseWindowOnWin32();
	#endif //WIN32

  glutMainLoop();

	return 0;
}
